import h5py

model = 'NN_1000-200-50-10-1_reg1e-3_lossMSE'
folder = 'results/MA_regressions/'
vehicles = ["CitroenC4Picasso","Mazda3","MercedesAMG550","NissanQashqai","OpelInsignia",
        "Peugeot307","Peugeot3008","RenaultCaptur","RenaultScenic","VWPassat"]

hf2 = h5py.File(folder + f'regression_{model}.h5', 'w')

for k in range(len(vehicles)):
    hf = h5py.File(folder + 'regression_' + model + '__' + vehicles[k] + '.h5', 'r')
    hf2.create_dataset(vehicles[k] + '_MA_train', data=hf[vehicles[k] + '_MA_train'], compression="gzip")
    hf2.create_dataset(vehicles[k] + '_MA_valid', data=hf[vehicles[k] + '_MA_valid'], compression="gzip")
    hf2.create_dataset(vehicles[k] + '_MA_test', data=hf[vehicles[k] + '_MA_test'], compression="gzip")
    hf2.create_dataset(vehicles[k] + '_MA_test_nv', data=hf[vehicles[k] + '_MA_test_nv'], compression="gzip")
    hf2.create_dataset(vehicles[k] + '_speeds_train', data=hf[vehicles[k] + '_speeds_train'], compression="gzip")
    hf2.create_dataset(vehicles[k] + '_speeds_valid', data=hf[vehicles[k] + '_speeds_valid'], compression="gzip")
    hf2.create_dataset(vehicles[k] + '_speeds_test', data=hf[vehicles[k] + '_speeds_test'], compression="gzip")
    hf.close()

hf2.close()